// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>
#include <vector>
#include <cstdio>

using namespace std;

typedef long long llint;

const int MAXN = 300030;

char a[MAXN];
int L[MAXN];
vector<int> v[26];

void add(int x, int v) {
  for (++x; x < MAXN; x += x&-x)
    L[x] += v;
}

int sum(int x) {
  int r = 0;
  for (++x; x; x -= x&-x)
    r += L[x];
  return r;
}

int main(void) {
  int n;
  scanf("%d", &n);
  scanf("%s", a);
  
  for (int i = 0; i < n; ++i) {
    v[a[i]-'A'].push_back(i);
    add(i, +1);
  }

  llint ans = 0;
  for (int i = 0; i < n; ++i) {
    int c = a[i] - 'A';
    int j = v[c].back();
    v[c].pop_back();

    if (j <= i) continue;

    ans += sum(j) - sum(i-1);
    add(j, -1);
    add(i, -1);
  }

  printf("%lld\n", ans);
  return 0;
}
